IF EXISTS (SELECT * FROM SYS.TABLES WHERE NAME = 'CG_FND_VERBA_LIB')
BEGIN
	GOTO FINAL
END

CREATE TABLE [dbo].[CG_FND_VERBA_LIB](
	[CD_EMP] [int] NOT NULL,
	[CD_FND_VERBA] [int] NOT NULL,
	[CD_USU_FORN] [int] NULL,
	[CD_USU] [int] not NULL,
	[DT_LIB] [date] NOT NULL,
	[HR_LIB] [datetime] NOT NULL,
 CONSTRAINT [PK_CG_FND_VERBA_LIB] PRIMARY KEY CLUSTERED 
(
	[CD_EMP] ASC,
	[CD_FND_VERBA] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 80) ON [PRIMARY]
) ON [PRIMARY] 

FINAL:
GO

IF NOT (OBJECT_ID('FK_CG_FND_VERBA_LIB_CG_FND_VERBA')) IS NULL
BEGIN
	GOTO FINAL
END

ALTER TABLE [dbo].[CG_FND_VERBA_LIB]  WITH CHECK ADD  CONSTRAINT [FK_CG_FND_VERBA_LIB_CG_FND_VERBA] FOREIGN KEY([CD_FND_VERBA], [CD_EMP])
REFERENCES [dbo].[CG_FND_VERBA] ([CD_FND_VERBA], [CD_EMP])

ALTER TABLE [dbo].[CG_FND_VERBA_LIB] CHECK CONSTRAINT [FK_CG_FND_VERBA_LIB_CG_FND_VERBA]


FINAL:

GO

IF NOT (OBJECT_ID('FK_CG_FND_VERBA_LIB_GLB_USU')) IS NULL
BEGIN
	GOTO FINAL
END


ALTER TABLE [dbo].[CG_FND_VERBA_LIB]  WITH CHECK ADD  CONSTRAINT [FK_CG_FND_VERBA_LIB_GLB_USU] FOREIGN KEY([CD_USU])
REFERENCES [dbo].[GLB_USU] ([CD_USU])

ALTER TABLE [dbo].[CG_FND_VERBA_LIB] CHECK CONSTRAINT [FK_CG_FND_VERBA_LIB_GLB_USU]


FINAL:
GO



IF NOT (OBJECT_ID('FK_CG_FND_VERBA_LIB_GLB_USU')) IS NULL
BEGIN
	GOTO FINAL
END


ALTER TABLE [dbo].[CG_FND_VERBA_LIB]  WITH CHECK ADD  CONSTRAINT [FK_CG_FND_VERBA_LIB_GLB_USU_FORN] FOREIGN KEY([CD_EMP],[CD_USU_FORN])
REFERENCES [dbo].[GLB_USU_FORN] ([CD_EMP],[CD_USU])

ALTER TABLE [dbo].[CG_FND_VERBA_LIB] CHECK CONSTRAINT [FK_CG_FND_VERBA_LIB_GLB_USU]


FINAL:
GO